#define NEED_CPU_REG_SHORTCUTS 1
#include "bochs.h"
#define LOG_THIS BX_CPU_THIS_PTR
#if BX_USE_CPU_SMF
#define this (BX_CPU(0))
#endif

void BX_CPU_C::EXEC_leave_I16fix0(int seg,Bit8u* imm)
{
Bit32u temp_EBP;
Bit16u arg0;

arg0=0;

#if BX_CPU_LEVEL < 2
BX_PANIC(("LEAVE: not supported by 8086!\n"));
#else
invalidate_prefetch_q();
#if BX_CPU_LEVEL >= 3
if (BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.d_b)
  temp_EBP = EBP;
else
#endif
  temp_EBP = BP;

if ( protected_mode() ) {
  if (BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.c_ed) { /* expand up */
    if (temp_EBP <= BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.limit_scaled) {
      BX_PANIC(("LEAVE: BP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].limit\n"));
      exception(BX_SS_EXCEPTION, 0, 0);
      return;
    }
  } else { /* normal */
    if (temp_EBP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.limit_scaled) {
      BX_PANIC(("LEAVE: BP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].limit\n"));
      exception(BX_SS_EXCEPTION, 0, 0);
      return;
    }
  }
}
// delete frame
#if BX_CPU_LEVEL >= 3
if (BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.d_b)
  ESP = EBP;
else
#endif
  SP = BP;
// restore frame pointer
#if 16 == 32
Bit32u temp32;
pop_32(&temp32);
EBP = temp32;
#else
Bit16u temp16;
pop_16(&temp16);
BP = temp16;
#endif
#endif
}

void BX_CPU_C::EXEC_leave_I32fix0(int seg,Bit8u* imm)
{
Bit32u temp_EBP;
Bit32u arg0;

arg0=0;

#if BX_CPU_LEVEL < 2
BX_PANIC(("LEAVE: not supported by 8086!\n"));
#else
invalidate_prefetch_q();
#if BX_CPU_LEVEL >= 3
if (BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.d_b)
  temp_EBP = EBP;
else
#endif
  temp_EBP = BP;

if ( protected_mode() ) {
  if (BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.c_ed) { /* expand up */
    if (temp_EBP <= BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.limit_scaled) {
      BX_PANIC(("LEAVE: BP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].limit\n"));
      exception(BX_SS_EXCEPTION, 0, 0);
      return;
    }
  } else { /* normal */
    if (temp_EBP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.limit_scaled) {
      BX_PANIC(("LEAVE: BP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].limit\n"));
      exception(BX_SS_EXCEPTION, 0, 0);
      return;
    }
  }
}
// delete frame
#if BX_CPU_LEVEL >= 3
if (BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.d_b)
  ESP = EBP;
else
#endif
  SP = BP;
// restore frame pointer
#if 32 == 32
Bit32u temp32;
pop_32(&temp32);
EBP = temp32;
#else
Bit16u temp16;
pop_16(&temp16);
BP = temp16;
#endif
#endif
}
